#!/usr/bin/perl -w
# file gfx1.0.pl     19 July 2003 written by  Kevin Cole
# Perl program to accept GF number and create TeX output file
# for printing the corresponding boundary value problem,
# formal solution, and closed form solution with the specific GF.
# Begin with a main program to call subroutines.
# ***********************************
# History***************************
# 7/8/02  version 5.  transient 1-D rectangular cases 
# 5/29/03 version 6.  Added steady cases when 'T' descriptor not present
# 7/08/03 gfx1.0.pl  use Perl/Tk for GUI input; drop closed-form temp.
# 7/19/03 gfx1.1.pl  improve Perl/Tk GUI
# 5/11/04 tslab1.2.pl include images; one button operation, better menus
#	use strict;
use Tk;
   my ($view,$adata,$dirname,%boundary,%bval,%tval,
       $result_g,$result_t,$result_b0,$result_bL);
   my ($result_x0,$result_xL,$sr_x0,$sr_xL,$sr_b0,$sr_bL);
   my (@list,@shortblist,@longblist,@glist);
   my ($xval,$x0,$xL,$b0,$bL,$g,$bb,$tt);
# set previewer appropriate for computer operating system
    $view = 'xdvi';   # for Unix previewer
    if($Tk::platform eq 'MSWin32') {$view = 'yap';} # For Windows previewer  
# set name of subdirectory where needed files are located; set working director
         $dirname = 'gf_files';
         chdir "$dirname" or die "cannot chdir to $dirname : $!";
# set up hash for boundary values.
  %boundary = ("none"=> 0,
	       "Type 1.  Specified temperature" => 1,
	       "Type 2.  Specified flux" => 2,
	       "Type 3.  Fluid temp. for convection" => 3);
  %bval = ("is zero"=> 0,
	   "is constant"=>1,
	   "is a function of x"=>'-',
	   "is a function of time"=>'-',
           "is a function"=>'-');
  %tval = ("is zero"=> 'T0',
	   "is constant"=>'T1',
	   "is a function of x"=>'T-');
# initialize values
  $x0 = ""; $xL = ""; $b0 = ""; $bL = ""; $g = "";
  $result_x0 = 'Type 1.  Specified temperature';
  $result_xL = 'Type 1.  Specified temperature';
  $result_bL = 'is constant';
  $result_b0 = 'is constant';
  $result_g = 'is zero';
  $result_t = 'is zero';
  $tt = 'transient';
  $xval = 'finite';
# set up lists for use with boundary, initial, and generation menus
  @shortblist = ('is zero','is constant');
  @longblist = ( 'is zero','is constant','is a function of time');
  @glist = ('is zero',	'is constant','is a function');
# read configuration from pre-existing file
#	  my $file2 = 'config.dat';
#          open FILEIN, "<$file2";
#          $view  = <FILEIN>;
#   	  chomp($view); 
# Set up Graphic interface for user input.
my $mw = MainWindow->new;
  $mw->title("Tslab");
# add menubar
  $mw->configure(-menu=> my $menubar = $mw->Menu);
  my $file = $menubar->cascade(-label => '~File');
#  my $edit = $menubar->cascade(-label => '~Edit');
  my $help = $menubar->cascade(-label => '~Help');
# configure menubar items
  $file ->command(-label => 'Exit', -command => sub { exit});
# create daughter window to configure input carefully
#  $edit ->command(-label => 'Configure', -command => sub {
#      $view = configoutput();
#              });
  $help ->command(-label => 'Number System Tutorial', -command =>sub { 
      printhelp($view)	 });
  $help ->separator;
  $help ->command(-label => 'About TSLAB', -command=> sub {
    showerror("Program TSLAB \n
 version 1.2 Copyright (C) 2004 by Kevin D. Cole \n\n
This program is free software\; you can redistribute it and/or\n
modify it under the terms of the GNU General Public License\n
as published by the Free Software Foundation; either version 2\n
of the License, or (at your option) any later version.\n\n
This program is distributed in the hope that it will be useful,\n
but WITHOUT ANY WARRANTY\; without even the implied warranty of\n
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n
GNU General Public License for more details.\n\n
You should have received a copy of the GNU General Public License\n
along with this program; if not, write to the Free Software\n
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n"
	,"About Tslab" ) 
     });
# end of menubar, now continue to content of program window.
  my $top_label = $mw->Label(-text => 
  "Temperature in a one-dimensional (slab) body by the method of Green's functions.\n
Select body size and heating heating conditions, then select 
\"show temperature\"  (Or, enter the heat transfer number directly). ",
   -justify=>'left')
    ->grid(-row=>0,-column=>0,-columnspan=>3);
# frame for steady-transient choice
  my $t_frame = $mw->Frame(-borderwidth => 4, -relief => 'groove',
		)->grid(-row=>1,-column=>0,-columnspan => 3,
			      -sticky=>'ew');
# frame for body shape
  my $x_frame = $mw->Frame(-borderwidth => 4, -relief => 'groove',
#			   -label=>'Body size:',
		      )->grid(-row=>2,-column=>0,-columnspan => 3,
			      -sticky=>'ew');
# Frame for images of body shape.
  my $image_frame = $mw->Frame(-borderwidth =>2, -relief => 'groove',)
    ->grid(-row =>3, -column=>0,-columnspan=>3,-sticky=>'ew');
# assign image files, located in correct subdirectory, to variables
my $fig1 = $mw->Photo(-file => 'slab1.gif');
my $fig2 = $mw->Photo(-file => 'slab2.gif');
my $fig3 = $mw->Photo(-file => 'slab3.gif');
# Frame for energy genertion.
  my $g_frame = $mw->Frame(-borderwidth => 4, -relief => 'groove',
			 -label=>"Internal energy generation",
   		 )->grid(-row=>5,-column=>0,-sticky=>'nsew');
 my $g_om = $g_frame->Optionmenu(  -variable=>\$result_g,
			     -options => [@glist],
        -command => sub{ $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval); },   
                         )->pack(-fill=>'x');
# Frame for initial condition
  my $init_frame = $mw->Frame(-borderwidth => 4, -relief => 'groove',
			 -label=>"Initial condition",
   		 )->grid(-row=>4,-column=>0,-sticky=>'nsew');
 my $init_om = $init_frame->Optionmenu(  -variable=>\$result_t,
			     -options => ['is zero',
					  'is constant',
					  'is a function of x'],
        -command => sub{ $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval); },   
                         )->pack(-fill=>'x');
# Frame for boundary at x=0.
  my $b0_frame = $mw ->Frame(-borderwidth => 4, 
			    -relief => 'groove',
			    -label => 'Boundary at x=0')
    ->grid(-row=>4,-column=>1,-columnspan=>2,-sticky=>'nsew');  
  my $b0_type_om = $b0_frame ->Optionmenu(  -variable=>\$result_x0,
		     -options => ['Type 1.  Specified temperature' ,
                                  'Type 2.  Specified flux',
			 'Type 3.  Fluid temp. for convection'], 
        -command => sub{ $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval); },   			
		    )->pack(-fill=>'x');
  my $b0_value_be = $b0_frame ->Optionmenu(-variable=>\$result_b0,
		    -options=>[@longblist],
        -command => sub{ $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval); },)   
     ->pack(-fill=>'x');
#
# Frame for boundary at x=L.
 my $bL_frame = $mw ->Frame(-borderwidth => 4, 
			    -relief => 'groove',
			    -label => 'Boundary at x=L')
    ->grid(-row=>5,-column=>1,-columnspan=>2,-sticky=>'nsew');  
 my $bL_type_om = $bL_frame ->Optionmenu(  -variable=>\$result_xL,
			     -options => ['Type 1.  Specified temperature' ,
                             'Type 2.  Specified flux',
			  'Type 3.  Fluid temp. for convection'], 
        -command => sub{ $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval); },   
                         )->pack;
  my $bL_value_be = $bL_frame ->Optionmenu(-variable=>\$result_bL,
		    -options=>[@longblist],
        -command => sub{ $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval); },   
     )->pack(-fill=>'x');
# Put images into image frame
my $p1 =  $image_frame->Button(-image => $fig1, -state => 'disabled' )
    ->pack(-side => 'left', expand=>1);
my $p2 =  $image_frame->Button(-image => $fig2, -state => 'disabled' )
    ->pack(-side => 'left', expand=>1);
my $p3 =  $image_frame->Button(-image => $fig3 )
    ->pack(-side => 'left', expand=>1);
# Radiobuttons, for Body Shape
  my @pl = qw/-side left -pady 2 -expand 1/;
  foreach $xsize ( 'infinite', 'semi-infinite', 'finite') {
	$x_frame->Radiobutton(
            -text     => $xsize,
            -variable => \$xval,
            -relief   => 'flat',
            -value    => $xsize,
			      -command=> sub {
	  if($xval eq 'infinite') {
# disable appropriate menus
	      $b0_type_om->configure(-state => 'disabled');
	      $b0_value_be->configure(-state => 'disabled');
	      $bL_type_om->configure(-state => 'disabled');
	      $bL_value_be->configure(-state => 'disabled'); 
		    $p1->configure(-state => 'normal');
		    $p2->configure(-state => 'disabled');
		    $p3->configure(-state => 'disabled');
          }  
	  if($xval eq 'semi-infinite') {          
	        $b0_type_om->configure(-state => 'normal');
		   $b0_value_be->configure(-state => 'normal');
		   $bL_type_om->configure(-state => 'disabled');
		   $bL_value_be->configure(-state => 'disabled'); 
		    $p2->configure(-state => 'normal');
		    $p1->configure(-state => 'disabled');
		    $p3->configure(-state => 'disabled');
          } 		   
	  if($xval eq 'finite') {       
	        $b0_type_om->configure(-state => 'normal');
		   $b0_value_be->configure(-state => 'normal');
		   $bL_type_om->configure(-state => 'normal');
		   $bL_value_be->configure(-state => 'normal');
		    $p3->configure(-state => 'normal');
		    $p1->configure(-state => 'disabled');
		    $p2->configure(-state => 'disabled'); 
	    }
# recompute GF number displayed in entry widget
       $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval);  
# end of subroutine called by radiobuton
      }
        )->pack(@pl);
    }
#
# Radiobuttons for steady-transient choice
  my @tl = qw/-side left -pady 2 -expand 1/;
#  my $tsize = 'transient';
  my $tval =  'transient';
  my $tflag = 'transient';
# 
  foreach my $tsize ( 'steady', 'transient') {
	$t_frame->Radiobutton(
            -text     => $tsize,
            -variable => \$tt,
            -relief   => 'flat',
            -value    => $tsize,
			      -command=> sub {
#	  print "Debug steady-trans.  Tsize = $tsize\n";
#	  print "Tflag = $tflag\n";
	  if($tt eq 'steady') {
# disable appropriate menus and remove menu items
# add or delete menu items depending on previous state with $tflag
# also change entrybox as appropriate for change from trans-steady.
	      $init_om->configure(-state => 'disabled');
	      if($tflag eq 'transient') {
		  $tflag = 'steady';
		  if($result_b0 eq 'is a function of time')
		  {$result_b0 = 'is constant'; }
		  if($result_bL eq 'is a function of time')
		  {$result_bL = 'is constant'; }
		  $b0_value_be->configure(-options=>[@shortblist] );
		  $bL_value_be->configure(-options=>[@shortblist] );        
	      }
          }  
	  if($tt eq 'transient') {          
	        $init_om->configure(-state => 'normal');
		if($tflag eq 'steady') {
		  $b0_value_be->configure(-options=>[@longblist]) ;
		  $bL_value_be-> configure(-options=>[@longblist]) ;
		  $tflag = 'transient';
                }
         } 		   
# recompute GF number displayed in entry widget
       $adata = &gfnumber( $tt,$xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,$result_t,
       $boundary,$bval,$tval);  
# end of subroutine called by radiobuton
      }
        )->pack(@tl);
    }
# Button to show GF number
#  my $shownum_butt = $mw->Button(-text=>"Show Heat Transfer Number",
#			    -command => sub {
#		   $adata =gfnumber($xval,$result_x0,$result_xL,
#       $result_b0,$result_bL,$result_g,$boundary,$bval) }, 
#                )->grid( -row=>5,-column=>0,-columnspan=>3);
# Bottom Frame for alternate input of GF number 
  my $gfnum_frame = $mw->Frame(-borderwidth => 2, 
			    -relief => 'groove', )
                            ->grid(-row=>6,-column=>0,
				   -columnspan=>3);
  my $gfnum_label=$gfnum_frame->Label(-text => 
		 "Heat transfer number:")
    ->pack(-side=> 'left',-expand=>1     );
  my $gfnum_entry = $gfnum_frame->Entry(-width => 11, textvariable => \$adata,
	    -takefocus => 1)->pack(-side=> 'left',
						-expand=>1     );
# Button to show Temperature
  my $gfnum_butt =$gfnum_frame->Button(-text => "Show Temperature", 
#				       -background =>'lightgreen',
				       -activebackground=>'lightgreen',
                   -command => sub {  
		  $adata = rundata($adata,$view); 
		  return $adata;
             }
	     )->pack(-side=> 'left',-expand=>1     );    
  $gfnum_entry->focus;
MainLoop;
#*****************************************************************************
#subroutine to set GF number from button and optionmenu data
sub gfnumber {
# assign names to the variable passed from the subroutine call 
    my($tt,$xval,$result_x0,$result_xL,$result_b0,$result_bL,$result_g,
       $result_t,$boundary,$bval,$tval) = @_;
    my ($x0,$xL,$b0,$bL,$g,$t,$adata,$bb);
# set values 
	 $x0 = $boundary{$result_x0};
  	 $xL = $boundary{$result_xL};
	 $b0 = $bval{$result_b0};
	 $bL = $bval{$result_bL};
	 $g =  $bval{$result_g};
         if($tt eq 'transient') { $t = $tval{$result_t};
	 		 } else {$t = '';}
	 $adata = 'X'."$x0"."$xL".'B'."$b0"."$bL";
	 if($xval eq 'infinite') { $adata ='X00';}
	 if($xval eq 'semi-infinite') { 
	   $adata = 'X'."$x0".'0'.'B'."$b0";}
         $adata = "$adata".'G'."$g"."$t";
    return $adata; }
#******************************************************************************
	sub rundata {
	my($adata,$view,$x0,$xL,$b0,$bL,$t,$g,$flag,@array);
	$adata = $_[0];
        $view = $_[1];
      if($view eq '') {
	  showerror("Error.  Output undefined.\n
           Run Configure from the Edit menu.");
           return; } 
# initialize values as spaces
	$x0 = ' ';
	$xL = ' ';
	$b0 = '-';
	$bL = '-';
	$t  = ' ';
	$g  = ' ';
        $flag = 0;
# Sift GF number and set error flags through a subroutine;
	@array = &siftdata($adata,$flag,$x0,$xL,$b0,$bL,$g,$t);
	($adata,$flag,$x0,$xL,$b0,$bL,$g,$t) = @array;
# print "Debug from sub rundata\n";
#	print '$data = '."$adata\n";
#           print '$x0 = '."$x0\n";
#           print '$xL = '."$xL\n";
#           print '$b0 = '."$b0\n";
#           print '$bL = '."$bL\n";
#           print '$t =  '."$t\n";
#           print '$g =  '."$g\n";
#           print '$flag = '."$flag\n";
# use flag values to print error messages
	if($flag ne 0) {
	  if($flag eq 3) { 
	     &showerror("Input number must be in the form X--B--G-\n 
		where \"-\" is 0, 1, 2, or 3.");
                $adata = "";
   		 return; }
	  if($flag eq 2) { 
		&showerror("First character must be an 'X'. "); 
                $adata = "";
		 return; }
	  if($flag eq 1) { 
		&showerror("Input number must be no more than 10 characters."); 
                $adata = "";
		 return; }
	}
#
# Input number is OK, now create output files.
# Open output file to contain TeX named after the GF number
# Increment file name using big loop counter $j
    $fshort = 'tslab';
    $fname = $fshort.'.tex';
    $fname = lc($fname);   # change all characters to lower case   
print "Output written to file $fname\n";
    open(FILE, ">$fname") || error('open','file');
# Convert $adata back to all uppercase.
    $adata = uc($adata);
# Write preamble into TeX file
    print FILE "\\documentclass{article}\n";
    print FILE "\\begin{document}\n";
# Call subroutine to write boundary value problem and temperature
if($t eq ' ') {
    print_steady_bvp($adata,$x0,$xL,$b0,$bL,$g); 
    print_steady_temp($adata,$x0,$xL,$b0,$bL,$g); 
#    print_GF_fin($adata,$x0,$xL);
#    print_steady_closed_form($adata,$x0,$xL,$b0,$bL,$g);                      
    }
else {    printbvp($adata,$x0,$xL,$b0,$bL,$t,$g);
	  print_temp($adata,$x0,$xL,$b0,$bL,$t,$g); 
      }
# Print appropriate Green's Function
	print_GF($adata,$x0,$xL,$t);
# Print author name, date, and web page URL
    print FILE "\\noindent Program {\\em TSLAB}, version 1.2, \\copyright 2004 
    by Kevin D. Cole. 
                  \\\\ \n";
    print FILE 'GF Library: www.engr.unl.edu/$\sim$glibrary/  '."\n";
# Write closing line to TeX document and close the file
    print FILE "\\end{document}\n";
    close(FILE);
# Run latex on file using "system" command, output is *.dvi 
    system ("latex  $fname" );
# Finally, display dvi file in appropriate viewer
    system ("$view $fshort" );
# reset working directory to where the main program is located.
#        chdir ".." or die "cannot chdir back to starting point: $!";
# end this subroutine
	return $adata;
    }
#******************************************************************************
	sub siftdata {
	my(@output,$data,$len,@char,$flag,$flag1,$let,
                 $x0,$xL,$b0,$bL,$g,$t,$loc,$i,$dum,$dum1);
# set input values from main program
	($data,$flag,$x0,$xL,$b0,$bL,$g,$t) = @_; 
	chomp $data;
	$data = uc($data); 	#change string to uppercase for easier sifting
	$flag = 0;		#initialize flag
#check input string for errors
# error number 1.  String is too long
	$len = length($data);	#find length of input number
        if ($len > 10) {
		$flag = 1;
 		@output  = ($data,$flag,$x0,$xL,$b0,$bL,$g);
		return @output;
	}
# Error 2.  First character must be x.
		if(substr($data,0,1) ne 'X')  {
		$flag = 2;
		@output = ($data,$flag,$x0,$xL,$b0,$bL,$g);
		return @output;
	}
# Error 3.  Wrong letter present; Must contain only X,B,G, 0,1,2 or 3:
# Read character data into array @char for easier manipulation.
	$i = 0; 		# begin loop with index zero offset
        while ($i <= ($len -1) )
	  {$char[$i] = substr($data,$i,1); 
	   $i = $i + 1;
          } 
# Next test characters one by one to see if any are NOT [0-3,X,B,G,T or -]
        $flag1 = 0;   # use flag to detect error in loop
        $i = 0;
        while ($i <= ($len-1) ) {
              if ($char[$i] =~/[^0-3XBGT\-]/ ) {
	      $flag1 = 1 ; }  #set flag if wrong type of letter present
	    $i = $i + 1;
           }
        if($flag1 ne 0) {
		$flag = 3;	
		@output = ($data,$flag,$x0,$xL,$b0,$bL,$g);
		return @output;
	}
# end of error block.  Remaining code is for good data.
#
# Read values following the zeroth character (which is X)
	$x0 = $char[1];
	$xL = $char[2];
# Check for construct X0I which can confuse the logic; swap values
      if (($x0 eq 0) and ($xL ne 0)) {
        $dum= $x0;
        $x0 = $xL;
        $xL = $dum;
     }
# Look for boundary information, given by presence of 'B'
          $loc = index($data,'B',0) ;
# Set boundary values when 'B' is present.
# Note that $bL is not set when $xL = 0 (that is for case XI0)
# And no boundary values are set for case X00
   if($loc != -1) {
          if ($x0 ne '0') {
	      if($char[3] eq 'B') {
		  $b0 = $char[4]; }
	      if($xL ne '0')  {$bL = $char[5]; }
	  }  	
   }	
# If boundary information is not 0 or 1, change to '-'.
    if(($b0 ne '0') and ($b0 ne '1')) {
       $b0 = '-'; }
    if(($bL ne '0') and ($bL ne '1')) {
       $bL = '-'; }
# Search remaining data for T-designation
# Index returns substring location, or -1 if substring is not found
          $loc = index($data,'T',0) ;
# Set value for $t to the character AFTER a 'T', else no change to $t
            if($loc != -1) { $t = $char[$loc+1]; }            
# Search for G designation
          $loc = index($data,'G',0) ;
# Set value for $g to the character after a 'G' 
            if($loc != -1) { $g = $char[$loc+1]; }            
# Allowed $t and $g values are ' ', 0, and 1.  Any others set to '-'
          if(($t ne ' ') and ($t ne 0) and ($t ne 1)) {$t = '-'}
          if(($g ne ' ') and ($g ne 0) and ($g ne 1)) {$g = '-'}
# Note that above method to set $t and $g allows any order of input.
#
# Reconstruct input data to make corrected GF number
# Three cases for body shape, X00, XI0, XIJ:
    $dum = 'X'.$x0.$xL ;
    if (($x0 ne 0) and ($xL ne 0)) {
       $dum1 = $dum.'B'.$b0.$bL ;  # XIJ case has 2 boundaries
    }
    else {
      if(($x0 ne 0) and( $xL eq 0)) {
	$dum1 = $dum.'B'.$b0 ;  # XI0 case has 1 boundary
      }
      else { $dum1 = $dum } # X00 case has no boundaries
    }
# Now add T or G designations if present
    if ($t ne ' ' ) {
       $dum1 = $dum1.'T'.$t ; }
    if ($g ne ' ') {
       $dum1 = $dum1.'G'.$g ; }
    $data = $dum1;
# return results:
	@output = ($data,$flag,$x0,$xL,$b0,$bL,$g,$t);
	return @output;
    }
#***********************************************************************
# Subroutine to note error 
   sub error {
       print "Error during $_[0] $_[1]\n";
       return;
       }
#********1*********2*********3*********4*********5*********6*********7**
# Subroutine to print boundary value problem
sub printbvp {
    my ($begineq,$endeq,$tdiffx,$tdifft,$ggen,$gconst,$kdt,$init,$typ1x0);
    my ($typ1xL,$typ2x0,$typ2xL,$typ3x0,$typ3xL);
    my ($adata,$x0,$xL,$b0,$bL,$t,$g,$dum,$dum1,$dum2,$dum3);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; 
    $b0 = $_[3];  $bL = $_[4]; $t = $_[5]; $g = $_[6];
# Write introductory sentence to TeX file
    print FILE "\\noindent Case $_[0] satisfies the following equations:\n";
# set character data needed
    $begineq = '\begin{eqnarray*}';
    $endeq = '\end{eqnarray*}';
    $tdiffx = '\frac{\partial^2 T}{\partial x^2}';
    $tdifft = '\frac{1}{\alpha} \frac{\partial T}{\partial t}';
    $ggen = '+ \frac{g(x,t)}{k}';
    $gconst = '+ \frac{g_0}{k}';
    $kdt = 'k\frac{\partial T}{\partial x}';
    $init = 'T(x,t=0) & = &';
    $typ1x0 = 'T(x=0,t) & = &';
    $typ1xL = 'T(x=L,t) & = &';
    $typ2x0 = 'k \left. \frac{\partial T}{\partial x} \right|_{x=0} &=&';
    $typ2xL = 'k \left. \frac{\partial T}{\partial x} \right|_{x=L} &=&';
    $typ3x0 = 'k \left. \frac{\partial T}{\partial x}';
      $typ3x0 = $typ3x0.' \right|_{x=0} + h_1T_{x=0} &=&';
    $typ3xL = 'k \left. \frac{\partial T}{\partial x}';
      $typ3xL = $typ3xL.'\right|_{x=L} + h_2T_{x=L} &=&';
# Open math environment in TeX file
    print FILE "$begineq\n";
#
# DIFFERENTIAL EQUATION. Compose and write TeX characters into file.
# First set the energy generation term and the equal sign
	if(($g eq ' ') or ($g eq '0'))  {
	    $dum1 = '&=&'; }
	    else {
		$dum1 = $ggen.'& = &';
		if($g eq '1') { $dum1 = $gconst.'& = &'; }
	}
# then assemble the whole equation and print it
    $dum = $tdiffx.$dum1.$tdifft;
# If no T-designation given, assume steady diff. eq.
#    if($t eq ' ') {
#      $dum =  $tdiffx.$dum1.'0'; 
#     }
# print out diff. eq.  Note no closing carriage return for output line
	    print FILE $dum;
#
# BOUNDARY CONDITION at x=0 (skip if ax = 0)
	if($x0 ne '0')  {
# for type 1 boundary:
	  if($x0 eq '1')  {
	      $dum = $typ1x0.'T_1(t)';
	      if($b0 eq '0') { $dum = $typ1x0.'0'; }
	      if($b0 eq '1') { $dum = $typ1x0.'T_1'; }
	  }
# for type 2 boundary:
	 if($x0 eq '2')  {
	     $dum = '-'.$typ2x0.'q_1(t)';
	     if($b0 eq '0') { $dum = '-'.$typ2x0.'0'; }
	     if($b0 eq '1') { $dum = '-'.$typ2x0.'q_1'; }
	  }
# for type 3 boundary
	if($x0 eq '3')  {
	    $dum = '-'.$typ3x0.'h_1 T_{\infty 1}(t)'; 
	    if($b0 eq '0') { $dum = '-'.$typ3x0.'0'; }
	    if($b0 eq '1') { $dum = '-'.$typ3x0.'h_1 T_{\infty 1}'; }
	  }
# write out boundary condition at x=0
# Note \\\\ signals next line of multi-line formula, \n is carriage return
	  print FILE "\\\\  \n $dum";
# end of if block for boundary at x=0
	}
#
# BOUNDARY AT x=L.  Unlike x=0 side, no minus sign needed for type 2 and 3.
	if($xL ne '0')  {
# for type 1 boundary:
	  if($xL eq '1')  {
	      $dum = $typ1xL.'T_2(t)';
	      if($bL eq '0') { $dum = $typ1xL.'0'; }
	      if($bL eq '1') { $dum = $typ1xL.'T_2'; }
	  }
# for type 2 boundary:
	 if($xL eq '2')  {
	     $dum = $typ2xL.'q_2(t)';
	     if($bL eq '0') { $dum = $typ2xL.'0'; }
	     if($bL eq '1') { $dum = $typ2xL.'q_2'; }
	  }
# for type 3 boundary
	if($xL eq '3')  {
	    $dum = $typ3xL.'h_2 T_{\infty 2}(t)';
	    if($bL eq '0') { $dum = $typ3xL.'0'; }
	    if($bL eq '1') { $dum = $typ3xL.'h_2 T_{\infty 2}'; }
	  }
# write out boundary condition at x=L
	  print FILE "\\\\ \n $dum";
# end of if block for boundary at x=L
	}
#
# INITIAL CONDITION.  Null condition is character "space"
	if($t ne ' ')  {
# default is most general case
	  $dum = $init.'T_0(x)';	
	  if($t eq '0') { $dum = $init.'0'; }
	  if($t eq '1') { $dum = $init.'T_0'; }
# now write out initial condition, no carriage return at end of line
	  print FILE "\\\\ \n $dum" ;
	}
# Boundary value problem is complete. 
# Close math environment, first carriage return closes previous line
    print FILE "\n $endeq \n";
    return;
        }
#********1*********2*********3*********4*********5*********6*********7**
# Subroutine to print STEADY boundary value problem
sub print_steady_bvp {
    my ($begineq,$endeq,$tdiffx,$ggen,$gconst,$typ1x0);
    my ($typ1xL,$typ2x0,$typ2xL,$typ3x0,$typ3xL);
    my ($adata,$x0,$xL,$b0,$bL,$g,$dum,$dum1,$dum2,$dum3);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; 
    $b0 = $_[3];  $bL = $_[4]; $g = $_[5]; 
# Write introductory sentence to TeX file
    print FILE "\\noindent Case $_[0] satisfies the following equations:\n";
# set character data needed
    $begineq = '\begin{eqnarray*}';
    $endeq = '\end{eqnarray*}';
    $tdiffx = '\frac{\partial^2 T}{\partial x^2}';
    $ggen = '+ \frac{g(x)}{k}';
    $gconst = '+ \frac{g_0}{k}';
#    $kdt = 'k\frac{\partial T}{\partial x}';
#    $init = 'T(x,t=0) & = &';
    $typ1x0 = 'T(x=0,t) & = &';
    $typ1xL = 'T(x=L,t) & = &';
    $typ2x0 = 'k \left. \frac{\partial T}{\partial x} \right|_{x=0} &=&';
    $typ2xL = 'k \left. \frac{\partial T}{\partial x} \right|_{x=L} &=&';
    $typ3x0 = 'k \left. \frac{\partial T}{\partial x}';
      $typ3x0 = $typ3x0.' \right|_{x=0} + h_1T_{x=0} &=&';
    $typ3xL = 'k \left. \frac{\partial T}{\partial x}';
      $typ3xL = $typ3xL.'\right|_{x=L} + h_2T_{x=L} &=&';
# Open math environment in TeX file
    print FILE "$begineq\n";
#
# DIFFERENTIAL EQUATION. Compose and write TeX characters into file.
# First set the energy generation term and the equal sign
	if(($g eq ' ') or ($g eq '0'))  {
	    $dum1 = '&=&'; }
	    else {
		$dum1 = $ggen.'& = &';
		if($g eq '1') { $dum1 = $gconst.'& = &'; }
	}
# then assemble the whole equation and print it
    $dum = $tdiffx.$dum1.'0';
# print out diff. eq.  Note no closing carriage return for output line
	    print FILE $dum;
#
# BOUNDARY CONDITION at x=0 (skip if ax = 0)
	if($x0 ne '0')  {
# for type 1 boundary:
	  if($x0 eq '1')  {
	      $dum = $typ1x0.'T_1';
	      if($b0 eq '0') { $dum = $typ1x0.'0'; }
	      	  }
# for type 2 boundary:
	 if($x0 eq '2')  {
	     $dum = '-'.$typ2x0.'q_1';
	     if($b0 eq '0') { $dum = '-'.$typ2x0.'0'; }
	     	  }
# for type 3 boundary
	if($x0 eq '3')  {
	    $dum = '-'.$typ3x0.'h_1 T_{\infty 1}'; 
	    if($b0 eq '0') { $dum = '-'.$typ3x0.'0'; }
	    	  }
# write out boundary condition at x=0
# Note \\\\ signals next line of multi-line formula, \n is carriage return
	  print FILE "\\\\  \n $dum";
# end of if block for boundary at x=0
	}
#
# BOUNDARY AT x=L.  Unlike x=0 side, no minus sign needed for type 2 and 3.
	if($xL ne '0')  {
# for type 1 boundary:
	  if($xL eq '1')  {
	      $dum = $typ1xL.'T_2';
	      if($bL eq '0') { $dum = $typ1xL.'0'; }
	      	  }
# for type 2 boundary:
	 if($xL eq '2')  {
	     $dum = $typ2xL.'q_2';
	     if($bL eq '0') { $dum = $typ2xL.'0'; }
	     	  }
# for type 3 boundary
	if($xL eq '3')  {
	    $dum = $typ3xL.'h_2 T_{\infty 2}';
	    if($bL eq '0') { $dum = $typ3xL.'0'; }
	    	  }
# write out boundary condition at x=L
	  print FILE "\\\\ \n $dum";
# end of if block for boundary at x=L
	}
#
# Boundary value problem is complete. 
# Close math environment, first carriage return closes previous line
    print FILE "\n $endeq \n";
    return;
        }
#********1*********2*********3*********4*********5*********6*********7**
# Subroutine to print temperature expression
    sub print_temp {
	my ($begineq,$endeq,$intt,$intxij,$intxi0,$intx00,$arginit,$argg);
	my ($argx0,$argxL,$dgdx0,$dgdxL,$alphonk,$dt,$dx,$a);
    my ($adata,$x0,$xL,$b0,$bL,$t,$g,$dum,$dum1,$dum2,$dum3,$flag);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; 
    $b0 = $_[3];  $bL = $_[4]; $t = $_[5]; $g = $_[6];
# set character data needed
	$begineq = '\begin{eqnarray*}';
	$endeq = '\end{eqnarray*}';
	$intt = '\int_{\tau=0}^t';
	$intxij = '\int_{x^{\prime} =0}^{L}';
	$intxi0 = '\int_{x^{\prime} =0}^{\infty}';
	$intx00 = '\int_{x^{\prime} = - \infty}^{\infty}';
	$arginit = '(x,t|x^{\prime} ,0) \; ';
	$argg =  '(x,t| x^{\prime} , \tau ) \; ';
	$argx0 = '(x,t|x^{\prime}=0,\tau ) \; ';
	$argxL = '(x,t|x^{\prime} =L,\tau ) \; ';
	$dgdx0 = '\left. \frac{\partial G}{\partial x}';
	$dgdx0 = $dgdx0.'\right|_{x^{\prime} =0}';
	$dgdxL = '\left. \frac{\partial G}{\partial x}';
	$dgdxL = $dgdxL.'\right|_{x^{\prime} =L}';
	$alphonk = '\frac{\alpha }{k}';
	$a = '\alpha ';
	$dt = 'd \tau ';
	$dx = 'd x^{\prime} ';
	$flag = 0;           # initialize flag for plus signs 
        $heatflag = 0;       # initialize flag for heating terms
# PRINT explanatory leader above temperature expression.
     print FILE "The temperature for case $_[0] is given by:\n";
	print FILE "$begineq\n";
	print FILE 'T(x,t) & = &  ';
# First address the initial condition term.
# Beginning with spatial integral.
	if(($t ne '0') and ($t ne ' '))  {  
	    if(($x0 eq '0') and ($xL eq '0')) {
		$dum1 = $intx00; }
	      else {
	        if($xL eq '0')  { $dum1 = $intxi0; }
	        else { $dum1 = $intxij; } 
	    }
# Then set the form of the initial condition inside the integral
	  $dum2 = 'T_0(x^{\prime}) \;  ';
	  if($t eq '1') { $dum2 = 'T_0 \; '; }
# Assemble the GF term
	  $dum3 = 'G'.'_{X'.$x0.$xL.'}';
	  $dum = $dum1.$dum2.$dum3.$arginit.$dx;
	  print FILE "$dum \n";    
	 $flag = 1;        # set flag if spatial integral is used 
	    $heatflag = 0;
# End of initial condition block
	}
#
# Energy generation term. Include for $g not zero.
	if(($g ne '0') and ($g ne ' '))  {
	    $heatflag = 1;
# First set spatial integral.
	    if(($x0 eq '0') and ($xL eq '0')) {
		$dum1 = $intx00; }
	      else {
		  if($xL eq '0')  {
	            $dum1 = $intxi0; }
	          else {$dum1 = $intxij; 
		  }
 	    }
# Set correct g-term
	  $dum2 = 'g(x^{\prime}, \tau ) \; ';
	  if($g eq '1') { $dum2 = 'g_0 \; '; }
# Set name of the GF
	  $dum3 = 'G'.'_{X'.$x0.$xL.'}';  
# Print integral term, add '+' and alignment if previous integral
	  if($flag == 1) {print FILE "\\\\ \n &+&"; }
# Assemble integral for generation term, and print it in 2 pieces
          $dum = $alphonk.$dum1.$intt;
	  print FILE $dum;
	  $dum =  $dum2.$dum3.$argg.$dt.$dx;
	  print FILE "$dum \n";
	  $flag = 1;       # set flag if generation integral used
	}
# End of energy generation block
#
# Block for boundary at x=0.  Not needed for X00 case.
	if(($b0 ne '0') and ($x0 ne '0'))  {
	    $heatflag = 1;
# For type 1 boundary
	  if($x0 eq '1')  {
	      $dum1 = 'T_1(\tau ) \; ';
	      if($b0 eq '1') { $dum1 = 'T_1 \; '; }
	      $dum = $a.$intt.$dum1.$dgdx0.$dt ;
	  }
# For type 2 boundary
	  if($x0 eq '2')  {
	      $dum1 = 'q_1 (\tau) \; ';
	      if($b0 eq '1') { $dum1 = 'q_1 \; '; }
	      $dum2= 'G'.'_{X'.$x0.$xL.'}'; 
	  $dum = $alphonk.$intt.$dum1.$dum2.$argx0.$dt ;
	  }
# For type 3 boundary
	  if($x0 eq '3')  {
	      $dum1 = 'h_1 T_{\infty 1} (\tau) \; '; 
	      if($b0 eq '1') { $dum1 = 'h_1 T_{\infty 1} \; '; }
	      $dum2 = 'G'.'_{X'.$x0.$xL.'}';
	      $dum = $alphonk.$intt.$dum1.$dum2.$argx0.$dt;
	  }
# Print integral term, add '+' if previous integral used
	  if($flag == 1) {print FILE "\\\\ \n &+&"; }
# Write output line for x=0 boundary term
	print FILE "$dum \n";
	  $flag = 1;  #set flag if boundary integral used
# End if IF-Block for x=0 boundary term
	}
#
# Block for x = L boundary.  Skip for bx = 0.
	if(($xL ne '0') and ($bL ne '0'))  {
	    $heatflag = 1;
# For type 1 boundary
	  if($xL eq '1')  {
	      $dum1 = 'T_2(\tau ) \; ';
	      if($bL eq '1') { $dum1 = 'T_2 \; '; }
	      $dum = $a.$intt.$dum1.$dgdxL.$dt;
	      $flag = -1;   #needs a minus sign in front
	  }
# For type 2 boundary
	  if($xL eq '2')  {
	      $dum1 = 'q_2 (\tau) \; '; 
	      if($bL eq '1') { $dum1 = 'q_2 \; '; }
	      $dum2=  'G'.'_{X'.$x0.$xL.'}';
	      $dum = $alphonk.$intt.$dum1.$dum2.$argxL.$dt;
	  }
# For type 3 boundary
	  if($xL eq '3')  {
	      $dum1 = 'h_2 T_{\infty 2} (\tau) \; ';
	      if($bL eq '1') { $dum1 = 'h_2 T_{\infty 2} \; '; }
	      $dum2 = 'G'.'_{X'.$x0.$xL.'}';
	      $dum = $alphonk.$intt.$dum1.$dum2.$argxL.$dt;
	  }
# Print integral term, add '+' if previous integral
	  if($flag == 1) {print FILE "\\\\ \n &+&"; }
	  if($flag == -1) {print FILE "\\\\ \n &-&"; }  #for minus sign needed
# Write output line for x=L boundary term
	  print FILE "$dum \n";
# End of IF-block for x=L boundary
	}
# finally, if all driving terms are zero, print a zero.
  if($heatflag eq 0) {
      print FILE "0\n"; }
#
# Close equation array
        print FILE "$endeq\n";
# Exit subroutine print_temp
        return;
         }
#********1*********2*********3*********4*********5*********6*********7**
# Subroutine to print fin GF below the formal solution
	sub print_GF{
	my($adata,$x0,$xL,$line1,$line2,$gname,$t,$dum);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; $t = $_[3];  
# print preamble to state the GF:
    print FILE "The Green's function is given by:";
    if($t eq ' ') {
	$dum ='s';}
        else { $dum = ''; }
# set the name of the GF file, must reside in same directory as pl
	$gname = "x"."$x0"."$xL"."$dum".".tex";
	open(FILEIN,"<$gname") || error('open','file');
# read all lines from input file and write to output file
    while (defined($line1 = <FILEIN>)) {
	chomp($line1);
    print FILE "$line1\n"; 
         }   
# add some space after the Green's function
	print FILE "\\vspace{0.1in}\n\n";
# close input file
	close(FILEIN);
	return;
	}
#********1*********2*********3*********4*********5*********6*********7**
# Subroutine to print STEADY temperature expression
    sub print_steady_temp {
	my ($begineq,$endeq,$intxij,$intxi0,$intx00,$argg);
	my ($argx0,$argxL,$dgdx0,$dgdxL,$kinverse,$dx);
    my ($adata,$x0,$xL,$b0,$bL,$t,$g,$dum,$dum1,$dum2,$dum3,$flag);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; 
    $b0 = $_[3];  $bL = $_[4]; $g = $_[5]; 
# set character data needed
	$begineq = '\begin{eqnarray*}';
	$endeq = '\end{eqnarray*}';
#	$intt = '\int_{\tau=0}^t';
	$intxij = '\int_{x^{\prime} =0}^{L}';
	$intxi0 = '\int_{x^{\prime} =0}^{\infty}';
	$intx00 = '\int_{x^{\prime} = - \infty}^{\infty}';
#	$arginit = '(x,t|x^{\prime} ,0) \; ';
	$argg =  '(x| x^{\prime} ) \; ';
	$argx0 = '(x|x^{\prime}=0 ) \; ';
	$argxL = '(x|x^{\prime} =L ) \; ';
	$dgdx0 = '\left. \frac{\partial G}{\partial x\'}';
	$dgdx0 = $dgdx0.'\right|_{x^{\prime} =0}';
	$dgdxL = '\left. \frac{\partial G}{\partial x\'}';
	$dgdxL = $dgdxL.'\right|_{x^{\prime} =L}';
	$kinverse = '\frac{1}{k}';
#	$a = '\alpha ';
#	$dt = 'd \tau ';
	$dx = 'd x^{\prime} ';
	$flag = 0;           # initialize flag for plus signs 
        $heatflag = 0;       # initialize flag for heating terms
# PRINT explanatory leader above temperature expression.
     print FILE "The temperature for steady fin $_[0] is given by:\n";
	print FILE "$begineq\n";
	print FILE 'T(x) - T_{\infty} & = &  ';
# Energy generation term. Include for $g not zero.
	if(($g ne '0') and ($g ne ' '))  {
	    $heatflag = 1;
# First set spatial integral.
	    if(($x0 eq '0') and ($xL eq '0')) {
		$dum1 = $intx00; }
	      else {
		  if($xL eq '0')  {
	            $dum1 = $intxi0; }
	          else {$dum1 = $intxij; 
		  }
 	    }
# Set correct g-term
	  $dum2 = 'g(x^{\prime}) \; ';
	  if($g eq '1') { $dum2 = 'g_0 \; '; }
# Set name of the GF
	  $dum3 = 'G'.'_{X'.$x0.$xL.'}';  
# Assemble integral for generation term, and print it in 2 pieces
          $dum = $kinverse.$dum1;
	  print FILE $dum;
	  $dum =  $dum2.$dum3.$argg.$dx;
	  print FILE "$dum \n";
	  $flag = 1;       # set flag if generation integral used
	}
# End of energy generation block
#
# Block for boundary at x=0.  Not needed for X00 case.
	if(($b0 ne '0') and ($x0 ne '0'))  {
	    $heatflag = 1;
# For type 1 boundary
	  if($x0 eq '1')  {
	      $dum1 = '( T_1 - T_{\infty}) \; ';
	      $dum = $dum1.$dgdx0 ;
	  }
# For type 2 boundary
	  if($x0 eq '2')  {
	      $dum1 = 'q_1 \; ';
	      $dum2= 'G'.'_{X'.$x0.$xL.'}'; 
	  $dum = $kinverse.$dum1.$dum2.$argx0 ;
	  }
# For type 3 boundary
	  if($x0 eq '3')  {
	      $dum1 = 'h_1 (T_{\infty 1}- T_{\infty})  \; '; 
	      $dum2 = 'G'.'_{X'.$x0.$xL.'}';
	      $dum = $kinverse.$dum1.$dum2.$argx0;
	  }
# Print integral term, add '+' if previous integral used
	  if($flag == 1) {print FILE "\\\\ \n &+&"; }
# Write output line for x=0 boundary term
	print FILE "$dum \n";
	  $flag = 1;  #set flag if boundary integral used
# End if IF-Block for x=0 boundary term
	}
#
# Block for x = L boundary.  Skip for bx = 0.
	if(($xL ne '0') and ($bL ne '0'))  {
	    $heatflag = 1;
# For type 1 boundary
	  if($xL eq '1')  {
	      $dum1 = '(T_2 - T_{\infty})\; ';
	      $dum = $dum1.$dgdxL;
	      $flag = -1;   #needs a minus sign in front
	  }
# For type 2 boundary
	  if($xL eq '2')  {
	      $dum1 = 'q_2 \; '; 
	      $dum2=  'G'.'_{X'.$x0.$xL.'}';
	      $dum = $kinverse.$dum1.$dum2.$argxL;
	  }
# For type 3 boundary
	  if($xL eq '3')  {
	      $dum1 = 'h_2 (T_{\infty 2} - T_{\infty}) \; ';
	      $dum2 = 'G'.'_{X'.$x0.$xL.'}';
	      $dum = $kinverse.$dum1.$dum2.$argxL;
	  }
# Print integral term, add '+' if previous integral
	  if($flag == 1) {print FILE "\\\\ \n &+&"; }
	  if($flag == -1) {print FILE "\\\\ \n &-&"; }  #for minus sign needed
# Write output line for x=L boundary term
	  print FILE "$dum \n";
# End of IF-block for x=L boundary
	}
# finally, if all driving terms are zero, print a zero.
  if($heatflag eq 0) {
      print FILE "0\n"; }
#
# Close equation array
        print FILE "$endeq\n";
# Exit subroutine print_steady_temp
        return;
         }
#************************************************************************
	sub showerror {
#	$message = $_[0]
	if(! Exists($t1)) {
	  my $t1 = $mw->Toplevel();
        if($_[1] eq '') { $t1->title("Error")}
	  else { $t1->title("$_[1]") }
	  $t1->Label(-text=>$_[0],-anchor=>'e')->pack;
	  $t1->Button(-text => "OK", 
		      -command => sub {$t1->withdraw})->pack;
	  } else {
	    $t1-> deiconify();
	    $t1->raise();
	  }
	return;
    }
# ************************************************************************
          sub printhelp {
         my $view = $_[0];
      if($view eq '') {
	  showerror("Error.  Output undefined.\n
           Run Configure from the Edit menu.");
           return; } 
          system("$_[0] gfhelp"); # load help file in viewer
	  return;
}
# ########################################################################

