#!/usr/bin/perl -w
# file tfin1.2.pl     12 July 2003 written by  Kevin Cole
# Perl program to accept GF number and create TeX output file
# for printing the corresponding boundary value problem,
# formal solution, and closed form solution with the specific GF.
# Begin with a main program to call subroutines.
# ***********************************
# History***************************#
# 7/8/02  version 5.  transient 1-D rectangular cases 
# 5/29/03 version 6.  Added steady cases when 'T' descriptor not present
# 6/06/03 finx1.pl   1D fin with uniform cross section, steady for now. 
# 7/08/03 finx1.1.pl use Perl/Tk for GUI input; drop closed-form temp.
# 5/7/04  tfin1.2.pl add images for 3 body shapes
#####################################
#	use strict;
use Tk;
   my ($view,$adata,$dirname,%boundary,%bval,$result_g,$result_b0,$result_bL);
   my ($result_x0,$result_xL,$sr_x0,$sr_xL,$sr_b0,$sr_bL);
   my ($x0,$xL,$b0,$bL,$g,$bb);
    $view = 'xdvi';   # for Unix previewer
    if($Tk::platform eq 'MSWin32') {$view = 'yap';} # For Windows previewer  
# set name of subdirectory where needed files are located; set working director
         $dirname = 'gf_files';
         chdir "$dirname" or die "cannot chdir to $dirname : $!";
# set up hash for boundary values.
  %boundary = ("none"=> 0,
	       "Type 1.  Specified temperature" => 1,
	       "Type 2.  Specified flux" => 2,
	       "Type 3.  Fluid temp. for convection" => 3);
  %bval = ("is zero"=> 0,
	   "is constant"=>1,
	   "is a function of x"=>'-');
# initialize values
$x0 = ""; $xL = ""; $b0 = ""; $bL = ""; $g = "";
$xval ='finite';
$result_x0 = "Type 1.  Specified temperature";
$result_xL = "Type 1.  Specified temperature";
$result_b0 = "is constant";
$result_bL = "is zero";
$result_g = "is zero";
# read configuration from pre-existing file
#	  my $file2 = 'config.dat';
#   open(FILEIN, "<$file2") ||  &showerror("You need to Configure the
#        program.\n  Click on Edit -> Configure.");
#          open FILEIN, "<$file2";
#          $view  = <FILEIN>;
#   	  chomp($view); 
# Set up Graphic interface for user input.
my $mw = MainWindow->new;
  $mw->title("TFIN");
# add menubar
  $mw->configure(-menu=> my $menubar = $mw->Menu);
  my $file = $menubar->cascade(-label => '~File');
#  my $edit = $menubar->cascade(-label => '~Edit');
  my $help = $menubar->cascade(-label => '~Help');
# configure menubar items
  $file ->command(-label => 'Exit', -command => sub { exit});
# create daughter window to configure input carefully
#  $edit ->command(-label => 'Configure', -command => sub {
#      $view = configoutput();
#              });
  $help ->command(-label => 'Number System Tutorial', -command =>sub { 
      printhelp($view)	 });
  $help ->separator;
  $help ->command(-label => 'About TFIN', -command=> sub {
    showerror("Program TFIN \n
version 1.2 Copyright (C) 2004 by Kevin D. Cole \n\n
This program is free software\; you can redistribute it and/or\n
modify it under the terms of the GNU General Public License\n
as published by the Free Software Foundation; either version 2\n
of the License, or (at your option) any later version.\n\n
This program is distributed in the hope that it will be useful,\n
but WITHOUT ANY WARRANTY\; without even the implied warranty of\n
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n
GNU General Public License for more details.\n\n
You should have received a copy of the GNU General Public License\n
along with this program; if not, write to the Free Software\n
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n"
	,"About TFIN" ) 
     });
# end of menubar, now continue to content of program window.
  my $top_label = $mw->Label(-text => 
    "Temperature in a fin of uniform cross section by the method of Green's functions.\n
Select fin size and heating heating conditions, then select 
\"show temperature\"  (Or, enter the heat transfer number directly). ",
   -justify=>'left')
    ->grid(-row=>0,-column=>0,-columnspan=>3);
# frame for body shape
  my $x_frame = $mw->Frame(-borderwidth => 2, -relief => 'groove',
#			   -label=>'Fin size:',
		      )->grid(-row=>1,-column=>0,-columnspan=>3,
			      -sticky=>'ew');
# Frame for images of body shape.
  my $image_frame = $mw->Frame(-borderwidth =>2, -relief => 'groove',)
    ->grid(-row =>2, -column=>0,-columnspan=>3,-sticky=>'ew');
# assign image files, located in correct subdirectory, to variables
my $fig1 = $mw->Photo(-file => 'fininf.gif');
my $fig2 = $mw->Photo(-file => 'finsemi.gif');
my $fig3 = $mw->Photo(-file => 'finfinite.gif');
# Frame for energy genertion, will remain empty for TFIN
  my $g_frame = $mw->Frame(-borderwidth => 2, -relief => 'groove',
			 -label=>"Internal energy generation",
   		 )->grid(-row=>4,-column=>0,-sticky=>'nsew');
 my $g_om = $g_frame->Optionmenu(  -variable=>\$result_g,
	 -options => ['is zero',
		  'is constant',
		  'is a function of x'],
        -command => sub{ $adata = &gfnumber( $xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,
       $boundary,$bval); },                      
                         )->pack(-fill=>'x');
# Frame for initial condition
  my $init_frame = $mw->Frame(-borderwidth => 4, -relief => 'groove',
   		 )->grid(-row=>3,-column=>0,-sticky=>'nsew');
# Frame for boundary at x=0.
  my $b0_frame = $mw ->Frame(-borderwidth => 2, 
			    -relief => 'groove',
			    -label => 'Boundary at x=0')
    ->grid(-row=>3,-column=>1,-columnspan=>2,-sticky=>'nsew');  
  my $b0_type_om = $b0_frame ->Optionmenu(  -variable=>\$result_x0,
		     -options => ['Type 1.  Specified temperature' ,
                                  'Type 2.  Specified flux',
			 'Type 3.  Fluid temp. for convection'],
        -command => sub{ $adata = &gfnumber( $xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,
       $boundary,$bval); },        
					    )->pack(-fill=>'x');
  my $b0_value_om = $b0_frame ->Optionmenu(  -variable=>\$result_b0,
			     -options => [ 'is constant',
					   'is zero' ],
        -command => sub{ $adata = &gfnumber( $xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,
       $boundary,$bval); },       
                         )->pack(-fill=>'x');
# Frame for boundary at x=L.
 my $bL_frame = $mw ->Frame(-borderwidth => 2, 
			    -relief => 'groove',
			    -label => 'Boundary at x=L')
    ->grid(-row=>4,-column=>1,-columnspan=>2,-sticky=>'nsew');  
 my $bL_type_om = $bL_frame ->Optionmenu(  -variable=>\$result_xL,
			     -options => ['Type 1.  Specified temperature' ,
                             'Type 2.  Specified flux',
			  'Type 3.  Fluid temp. for convection'],
        -command => sub{ $adata = &gfnumber( $xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,
       $boundary,$bval); },        
                         )->pack;
 my $bL_value_om = $bL_frame ->Optionmenu(  -variable=>\$result_bL,
			     -options => ['is zero',
					  'is constant'],
        -command => sub{ $adata = &gfnumber( $xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,
       $boundary,$bval); },       
					     )->pack(-fill=>'x');
# Put images into image frame
my $p1 =  $image_frame->Button(-image => $fig1, -state => 'disabled' )
    ->pack(-side => 'left', expand=>1);
my $p2 =  $image_frame->Button(-image => $fig2, -state => 'disabled' )
    ->pack(-side => 'left', expand=>1);
my $p3 =  $image_frame->Button(-image => $fig3 )
    ->pack(-side => 'left', expand=>1);
# Radiobuttons, for Body Shape
my @pl = qw/-side left -pady 2 -expand 1/;
# 
 foreach my $xsize ( 'infinite', 'semi-infinite', 'finite') {
	$x_frame->Radiobutton(
            -text     => $xsize,
            -variable => \$xval,
            -relief   => 'flat',
            -value    => $xsize,
			      -command=> sub {
	  if($xsize eq 'infinite') {
# disable appropriate menus and images
	      $b0_type_om->configure(-state => 'disabled');
	      $b0_value_om->configure(-state => 'disabled');
	      $bL_type_om->configure(-state => 'disabled');
	      $bL_value_om->configure(-state => 'disabled'); 
		    $p1->configure(-state => 'normal');
		    $p2->configure(-state => 'disabled');
		    $p3->configure(-state => 'disabled');
		          }  
	  if($xsize eq 'semi-infinite') {          
	        $b0_type_om->configure(-state => 'normal');
		   $b0_value_om->configure(-state => 'normal');
		   $bL_type_om->configure(-state => 'disabled');
		   $bL_value_om->configure(-state => 'disabled'); 
		    $p2->configure(-state => 'normal');
		    $p1->configure(-state => 'disabled');
		    $p3->configure(-state => 'disabled');
          } 		   
	  if($xsize eq 'finite') {       
	        $b0_type_om->configure(-state => 'normal');
		   $b0_value_om->configure(-state => 'normal');
		   $bL_type_om->configure(-state => 'normal');
		   $bL_value_om->configure(-state => 'normal'); 
		    $p3->configure(-state => 'normal');
		    $p1->configure(-state => 'disabled');
		    $p2->configure(-state => 'disabled');
	    }
# recompute GF number displayed in entry widget
       $adata = &gfnumber( $xval,$result_x0,
       $result_xL,$result_b0,$result_bL,$result_g,
       $boundary,$bval);  
# end of subroutine called by radiobuton
      }
        )->pack(@pl);
    }
# Button to show GF number
#  my $shownum_butt = $mw->Button(-text=>"Show Heat Transfer Number",
#			    -command => sub {$adata = &gfnumber(
#  $xval,$result_x0,$result_xL,$result_b0,$result_bL,$result_g,
#       $boundary,$bval); } )
#                ->grid( -row=>5,-column=>0,-columnspan=>3);
# Bottom Frame for alternate input of GF number 
  my $gfnum_frame = $mw->Frame(-borderwidth => 2, 
			    -relief => 'groove', )
                            ->grid(-row=>6,-column=>0,
				   -columnspan=>3);
  my $gfnum_label=$gfnum_frame->Label(-text => 
		 "Heat transfer number:")
    ->pack(-side=> 'left',-expand=>1     );
  my $gfnum_entry = $gfnum_frame->Entry(-width => 10, textvariable => \$adata,
	    -takefocus => 1)->pack(-side=> 'left',
						-expand=>1     );
  my $gfnum_butt =$gfnum_frame->Button(-text => "Show Temperature", 
	      -command => sub {  
		  $adata = rundata($adata,$view); 
		  return $adata;
             }
	     )->pack(-side=> 'left',-expand=>1     );    
  $gfnum_entry->focus;
MainLoop;
#*****************************************************************************
#subroutine to set GF number from button and optionmenu data
sub gfnumber {
# assign names to the variable passed from the subroutine call 
    my($xval,$result_x0,$result_xL,$result_b0,$result_bL,$result_g,
       $boundary,$bval) = @_;
    my ($x0,$xL,$b0,$bL,$g,$t,$adata,$bb);
# set values 
	 $x0 = $boundary{$result_x0};
  	 $xL = $boundary{$result_xL};
	 $b0 = $bval{$result_b0};
	 $bL = $bval{$result_bL};
	 $g =  $bval{$result_g};
	 $adata = 'X'."$x0"."$xL".'B'."$b0"."$bL";
	 if($xval eq 'infinite') { $adata ='X00';}
	 if($xval eq 'semi-infinite') { 
	   $adata = 'X'."$x0".'0'.'B'."$b0";}
         $adata = "$adata".'G'."$g";
    return $adata; 
}
#******************************************************************************
	sub rundata {
	my($adata,$view,$x0,$xL,$b0,$bL,$g,$flag,@array);
	$adata = $_[0];
        $view = $_[1];
      if($view eq '') {
	  showerror("Error.  Output undefined.\n
           Run Configure from the Edit menu.");
           return; } 
# initialize values as spaces
	$x0 = ' ';
	$xL = ' ';
	$b0 = '-';
	$bL = '-';
	$t  = ' ';
	$g  = ' ';
        $flag = 0;
# Sift GF number and set error flags through a subroutine;
	@array = &siftdata($adata,$flag,$x0,$xL,$b0,$bL,$g);
	($adata,$flag,$x0,$xL,$b0,$bL,$g) = @array;
# use flag values to print error messages
	if($flag ne 0) {
	  if($flag eq 4) { 
 &showerror("Steady only\; do not specify initial condition with T-.");
             $adata = "";
	     return; }
	  if($flag eq 3) { 
 &showerror("Input number must be in the form X--B--G-\n
where dashes ( - )  are numbers: 0, 1, 2, or 3.");
                $adata = "";
   		 return; }
	  if($flag eq 2) { 
		&showerror("First character must be an 'X'. "); 
                $adata = "";
		 return; }
	  if($flag eq 1) { 
  &showerror("Input number must be no more than 10 characters."); 
                $adata = "";
		 return; }
	}
#
# Input number is OK, now create output files.
# Open output file to contain TeX named after the GF number
# Increment file name using big loop counter $j
    $fshort = 'tfin';
    $fname = $fshort.'.tex';
    $fname = lc($fname);   # change all characters to lower case   
print "Output written to file $fname\n";
    open(FILE, ">$fname") || error('open','file');
# Convert $adata back to all uppercase.
    $adata = uc($adata);
# Write preamble into TeX file
    print FILE "\\documentclass{article}\n";
    print FILE "\\begin{document}\n";
# Call subroutine to write boundary value problem and temperature
if($t eq ' ') {
    print_steady_bvp($adata,$x0,$xL,$b0,$bL,$g); 
    print_steady_temp($adata,$x0,$xL,$b0,$bL,$g); 
    print_GF_fin($adata,$x0,$xL);
#    print_steady_closed_form($adata,$x0,$xL,$b0,$bL,$g);                      
    }
else {    printbvp($adata,$x0,$xL,$b0,$bL,$t,$g);
	  print_temp($adata,$x0,$xL,$b0,$bL,$t,$g); 
      }
# Print my name, date, and web page URL
    print FILE "\\noindent Program {\\em TFIN} \\copyright  2004
         by Kevin D. Cole. 
                  \\\\ \n";
    print FILE 'GF Library: www.engr.unl.edu/$\sim$glibrary/  '."\n";
# Write closing line to TeX document and close the file
    print FILE "\\end{document}\n";
    close(FILE);
# Run latex on file using "system" command, output is *.dvi 
    system ("latex  $fname" );
# Finally, display dvi file in appropriate viewer
    system ("$view $fshort" );
# reset working directory to where the main program is located.
#        chdir ".." or die "cannot chdir back to starting point: $!";
# end this subroutine
	return $adata;
    }
#********************************************************************************
	sub siftdata {
	my(@output,$data,$len,@char,$flag,$flag1,$let,
                 $x0,$xL,$b0,$bL,$g,$loc,$i,$dum,$dum1);
# set input values from main program
	($data,$flag,$x0,$xL,$b0,$bL,$g) = @_; 
	chomp $data;
	$data = uc($data); 	#change string to uppercase for easier sifting
	$flag = 0;		#initialize flag
#check input string for errors
# error number 1.  String is too long
	$len = length($data);	#find length of input number
        if ($len > 10) {
		$flag = 1;
 		@output  = ($data,$flag,$x0,$xL,$b0,$bL,$g);
		return @output;
	}
# Error 2.  First character must be x.
		if(substr($data,0,1) ne 'X')  {
		$flag = 2;
		@output = ($data,$flag,$x0,$xL,$b0,$bL,$g);
		return @output;
	}
# Error 3.  Wrong letter present; Must contain only X,B,G, 0,1,2 or 3:
# Read character data into array @char for easier manipulation.
	$i = 0; 		# begin loop with index zero offset
        while ($i <= ($len -1) )
	  {$char[$i] = substr($data,$i,1); 
	   $i = $i + 1;
          } 
# Next test characters one by one to see if any are NOT [0-3,X,B,G,T or -]
        $flag1 = 0;   # use flag to detect error in loop
        $i = 0;
        while ($i <= ($len-1) ) {
              if ($char[$i] =~/[^0-3XBGT\-]/ ) {
	      $flag1 = 1 ; }  #set flag if wrong type of letter present
	    $i = $i + 1;
           }
        if($flag1 ne 0) {
		$flag = 3;	
		@output = ($data,$flag,$x0,$xL,$b0,$bL,$g);
		return @output;
	}
# Error 4.  T designation present, this is a steady-only program
# Search remaining data for T-designation
# Index returns substring location, or -1 if substring is not found
          $loc = index($data,'T',0) ;
# For steady only, print message if T is found and return for new input
       if($loc != -1) {
		$flag = 4;
		@output = ($data,$flag,$x0,$xL,$b0,$bL,$g);
		return @output;
       }
# end of error block.  Remaining code is for good data.

# Read values following the zeroth character (which is X)
	$x0 = $char[1];
	$xL = $char[2];
# Check for construct X0I which can confuse the logic; swap values
      if (($x0 eq 0) and ($xL ne 0)) {
        $dum= $x0;
        $x0 = $xL;
        $xL = $dum;
     }
# Look for boundary information, given by presence of 'B'
          $loc = index($data,'B',0) ;
# Set boundary values when 'B' is present.
# Note that $bL is not set when $xL = 0 (that is for case XI0)
# And no boundary values are set for case X00
   if($loc != -1) {
          if ($x0 ne '0') {
	      if($char[3] eq 'B') {
		  $b0 = $char[4]; }
	      if($xL ne '0')  {$bL = $char[5]; }
	  }  	
   }	
# If boundary information is not 0 or 1, change to '-'.
    if(($b0 ne '0') and ($b0 ne '1')) {
       $b0 = '-'; }
    if(($bL ne '0') and ($bL ne '1')) {
       $bL = '-'; }
# Search for G designation
          $loc = index($data,'G',0) ;
# Set value for $g to the character after a 'G' 
            if($loc != -1) { $g = $char[$loc+1]; }            
# Allowed $g values are ' ', 0, and 1.  Any others set to '-'
          if(($g ne ' ') and ($g ne 0) and ($g ne 1)) {$g = '-'}
# Note that above method to set $t and $g allows any order of input.
#
# Reconstruct input data to make corrected GF number
# Three cases for body shape, X00, XI0, XIJ:
    $dum = 'X'.$x0.$xL ;
    if (($x0 ne 0) and ($xL ne 0)) {
       $dum1 = $dum.'B'.$b0.$bL ;  # XIJ case has 2 boundaries
    }
    else {
      if(($x0 ne 0) and( $xL eq 0)) {
	$dum1 = $dum.'B'.$b0 ;  # XI0 case has 1 boundary
      }
      else { $dum1 = $dum } # X00 case has no boundaries
    }
# Now add T or G designations if present
#    if ($t ne ' ' ) {
#       $dum1 = $dum1.'T'.$t ; }
    if ($g ne ' ') {
       $dum1 = $dum1.'G'.$g ; }
    $data = $dum1;
#
# return results:
	@output = ($data,$flag,$x0,$xL,$b0,$bL,$g);
	return @output;
    }
#***********************************************************************
# Subroutine to note error 
   sub error {
       print "Error during $_[0] $_[1]\n";
       return;
       }
#********1*********2*********3*********4*********5*********6*********7**
# Subroutine to print STEADY boundary value problem
sub print_steady_bvp {
    my ($begineq,$endeq,$tdiffx,$tfin,$ggen,$gconst,$typ1x0);
    my ($typ1xL,$typ2x0,$typ2xL,$typ3x0,$typ3xL);
    my ($adata,$x0,$xL,$b0,$bL,$g,$dum,$dum1,$dum2,$dum3);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; 
    $b0 = $_[3];  $bL = $_[4]; $g = $_[5]; 
# Write introductory sentence to TeX file
    print FILE "\\noindent Steady fin $_[0] satisfies the following equations:\n";
# set character data needed
    $begineq = '\begin{eqnarray*}';
    $endeq = '\end{eqnarray*}';
    $tdiffx = '\frac{\partial^2 T}{\partial x^2}';
    $tfin  = '- m^2 (T - T_{\infty})';
    $ggen = '+ \frac{g(x)}{k}';
    $gconst = '+ \frac{g_0}{k}';
#    $kdt = 'k\frac{\partial T}{\partial x}';
#    $init = 'T(x,t=0) & = &';
    $typ1x0 = 'T(x=0) - T_{\infty} & = &';
    $typ1xL = 'T(x=L) - T_{\infty} & = &';
    $typ2x0 = 'k \left. \frac{\partial T}{\partial x} \right|_{x=0} &=&';
    $typ2xL = 'k \left. \frac{\partial T}{\partial x} \right|_{x=L} &=&';
    $typ3x0 = 'k \left. \frac{\partial T}{\partial x}';
      $typ3x0 = $typ3x0.' \right|_{x=0} + h_1(T_{x=0}  - T_{\infty}) &=&';
    $typ3xL = 'k \left. \frac{\partial T}{\partial x}';
      $typ3xL = $typ3xL.'\right|_{x=L} + h_2(T_{x=L}  - T_{\infty}) &=&';
# Open math environment in TeX file
    print FILE "$begineq\n";
#
# DIFFERENTIAL EQUATION. Compose and write TeX characters into file.
# First set the energy generation term and the equal sign
	if(($g eq ' ') or ($g eq '0'))  {
	    $dum1 = '&=&'; }
	    else {
		$dum1 = $ggen.'& = &';
		if($g eq '1') { $dum1 = $gconst.'& = &'; }
	}
# then assemble the whole equation and print it
    $dum = $tdiffx.$tfin.$dum1.'0';
# print out diff. eq.  Note no closing carriage return for output line
	    print FILE $dum;
#
# BOUNDARY CONDITION at x=0 (skip if ax = 0)
	if($x0 ne '0')  {
# for type 1 boundary:
	  if($x0 eq '1')  {
	      $dum = $typ1x0.'T_1  - T_{\infty}';
	      if($b0 eq '0') { $dum = $typ1x0.'0'; }
	      	  }
# for type 2 boundary:
	 if($x0 eq '2')  {
	     $dum = '-'.$typ2x0.'q_1';
	     if($b0 eq '0') { $dum = '-'.$typ2x0.'0'; }
	     	  }
# for type 3 boundary
	if($x0 eq '3')  {
	    $dum = '-'.$typ3x0.'h_1 ( T_{\infty 1} - T_{\infty})'; 
	    if($b0 eq '0') { $dum = '-'.$typ3x0.'0'; }
	    	  }
# write out boundary condition at x=0
# Note \\\\ signals next line of multi-line formula, \n is carriage return
	  print FILE "\\\\  \n $dum";
# end of if block for boundary at x=0
	}
#
# BOUNDARY AT x=L.  Unlike x=0 side, no minus sign needed for type 2 and 3.
	if($xL ne '0')  {
# for type 1 boundary:
	  if($xL eq '1')  {
	      $dum = $typ1xL.'T_2 - T_{\infty}';
	      if($bL eq '0') { $dum = $typ1xL.'0'; }
	      	  }
# for type 2 boundary:
	 if($xL eq '2')  {
	     $dum = $typ2xL.'q_2';
	     if($bL eq '0') { $dum = $typ2xL.'0'; }
	     	  }
# for type 3 boundary
	if($xL eq '3')  {
	    $dum = $typ3xL.'h_2 (T_{\infty 2} - T_{\infty})';
	    if($bL eq '0') { $dum = $typ3xL.'0'; }
	    	  }
# write out boundary condition at x=L
	  print FILE "\\\\ \n $dum";
# end of if block for boundary at x=L
	}
#
# Boundary value problem is complete. 
# Close math environment, first carriage return closes previous line
    print FILE "\n $endeq \n";
    return;
        }
#*******1*********2*********3*********4*********5*********6*********7**
# Subroutine to print STEADY temperature expression
    sub print_steady_temp {
	my ($begineq,$endeq,$intxij,$intxi0,$intx00,$argg);
	my ($argx0,$argxL,$dgdx0,$dgdxL,$kinverse,$dx);
    my ($adata,$x0,$xL,$b0,$bL,$t,$g,$dum,$dum1,$dum2,$dum3,$flag);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; 
    $b0 = $_[3];  $bL = $_[4]; $g = $_[5]; 
# set character data needed
	$begineq = '\begin{eqnarray*}';
	$endeq = '\end{eqnarray*}';
#	$intt = '\int_{\tau=0}^t';
	$intxij = '\int_{x^{\prime} =0}^{L}';
	$intxi0 = '\int_{x^{\prime} =0}^{\infty}';
	$intx00 = '\int_{x^{\prime} = - \infty}^{\infty}';
#	$arginit = '(x,t|x^{\prime} ,0) \; ';
	$argg =  '(x| x^{\prime} ) \; ';
	$argx0 = '(x|x^{\prime}=0 ) \; ';
	$argxL = '(x|x^{\prime} =L ) \; ';
	$dgdx0 = '\left. \frac{\partial G}{\partial x\'}';
	$dgdx0 = $dgdx0.'\right|_{x^{\prime} =0}';
	$dgdxL = '\left. \frac{\partial G}{\partial x\'}';
	$dgdxL = $dgdxL.'\right|_{x^{\prime} =L}';
	$kinverse = '\frac{1}{k}';
#	$a = '\alpha ';
#	$dt = 'd \tau ';
	$dx = 'd x^{\prime} ';
	$flag = 0;           # initialize flag for plus signs 
        $heatflag = 0;       # initialize flag for heating terms
# PRINT explanatory leader above temperature expression.
     print FILE "The temperature for steady fin $_[0] is given by:\n";
	print FILE "$begineq\n";
	print FILE 'T(x) - T_{\infty} & = &  ';
# Energy generation term. Include for $g not zero.
	if(($g ne '0') and ($g ne ' '))  {
	    $heatflag = 1;
# First set spatial integral.
	    if(($x0 eq '0') and ($xL eq '0')) {
		$dum1 = $intx00; }
	      else {
		  if($xL eq '0')  {
	            $dum1 = $intxi0; }
	          else {$dum1 = $intxij; 
		  }
 	    }
# Set correct g-term
	  $dum2 = 'g(x^{\prime}) \; ';
	  if($g eq '1') { $dum2 = 'g_0 \; '; }
# Set name of the GF
	  $dum3 = 'G'.'_{X'.$x0.$xL.'}';  
# Assemble integral for generation term, and print it in 2 pieces
          $dum = $kinverse.$dum1;
	  print FILE $dum;
	  $dum =  $dum2.$dum3.$argg.$dx;
	  print FILE "$dum \n";
	  $flag = 1;       # set flag if generation integral used
	}
# End of energy generation block
#
# Block for boundary at x=0.  Not needed for X00 case.
	if(($b0 ne '0') and ($x0 ne '0'))  {
	    $heatflag = 1;
# For type 1 boundary
	  if($x0 eq '1')  {
	      $dum1 = '( T_1 - T_{\infty}) \; ';
	      $dum = $dum1.$dgdx0 ;
	  }
# For type 2 boundary
	  if($x0 eq '2')  {
	      $dum1 = 'q_1 \; ';
	      $dum2= 'G'.'_{X'.$x0.$xL.'}'; 
	  $dum = $kinverse.$dum1.$dum2.$argx0 ;
	  }
# For type 3 boundary
	  if($x0 eq '3')  {
	      $dum1 = 'h_1 (T_{\infty 1}- T_{\infty})  \; '; 
	      $dum2 = 'G'.'_{X'.$x0.$xL.'}';
	      $dum = $kinverse.$dum1.$dum2.$argx0;
	  }
# Print integral term, add '+' if previous integral used
	  if($flag == 1) {print FILE "\\\\ \n &+&"; }
# Write output line for x=0 boundary term
	print FILE "$dum \n";
	  $flag = 1;  #set flag if boundary integral used
# End if IF-Block for x=0 boundary term
	}
#
# Block for x = L boundary.  Skip for bx = 0.
	if(($xL ne '0') and ($bL ne '0'))  {
	    $heatflag = 1;
# For type 1 boundary
	  if($xL eq '1')  {
	      $dum1 = '(T_2 - T_{\infty})\; ';
	      $dum = $dum1.$dgdxL;
	      $flag = -1;   #needs a minus sign in front
	  }
# For type 2 boundary
	  if($xL eq '2')  {
	      $dum1 = 'q_2 \; '; 
	      $dum2=  'G'.'_{X'.$x0.$xL.'}';
	      $dum = $kinverse.$dum1.$dum2.$argxL;
	  }
# For type 3 boundary
	  if($xL eq '3')  {
	      $dum1 = 'h_2 (T_{\infty 2} - T_{\infty}) \; ';
	      $dum2 = 'G'.'_{X'.$x0.$xL.'}';
	      $dum = $kinverse.$dum1.$dum2.$argxL;
	  }
# Print integral term, add '+' if previous integral
	  if($flag == 1) {print FILE "\\\\ \n &+&"; }
	  if($flag == -1) {print FILE "\\\\ \n &-&"; }  #for minus sign needed
# Write output line for x=L boundary term
	  print FILE "$dum \n";
# End of IF-block for x=L boundary
	}
# finally, if all driving terms are zero, print a zero.
  if($heatflag eq 0) {
      print FILE "0\n"; }
#
# Close equation array
        print FILE "$endeq\n";
# Exit subroutine print_steady_temp
        return;
         }
#************************************************************************
# Subroutine to print fin GF below the formal solution
	sub print_GF_fin {
	my($adata,$x0,$xL,$line1,$line2,$gname);
# Redefine input variables for easier reading
    $adata = $_[0];  $x0 = $_[1]; $xL = $_[2]; 
# print preamble to state the GF:
    print FILE "The Green's function is given by:";
# set the name of the GF file, must reside in same directory as finx.2.pl
	$gname = "x"."$x0"."$xL"."fin.tex";
	open(FILEIN,"<$gname") || error('open','file');
# read all lines from input file and write to output file
    while (defined($line1 = <FILEIN>)) {
	chomp($line1);
    print FILE "$line1\n"; 
         }   
# add some space after the Green's function
	print FILE "\\vspace{0.1in}\n\n";
# close input file
	close(FILEIN);
	return;
	}
# ****************************************************************************
	sub showerror {
#	$message = $_[0]
	if(! Exists($t1)) {
	  my $t1 = $mw->Toplevel();
        if($_[1] eq '') { $t1->title("Error")}
	  else { $t1->title("$_[1]") }
	  $t1->Label(-text=>$_[0])->pack;
	  $t1->Button(-text => "OK", 
		      -command => sub {$t1->withdraw})->pack;
	  } else {
	    $t1-> deiconify();
	    $t1->raise();
	  }
	return;
    }
# ************************************************************************
          sub printhelp {
          my $view = $_[0];
      if($view eq '') {
	  showerror("Error.  Output undefined.\n
           Run Configure from the Edit menu.");
           return; } 
          system("$_[0] gfhelp"); # load help file in viewer
	  return;
}
# ########################################################################
  sub configoutput {
#	$data = $_[0]
  if(! Exists($t2)) {
	my $t2 = $mw->Toplevel();
	$t2->title("Configure");
	$t2->Label(-text=> "Identify operating system."
		     )->pack;
# frame for buttons at bottom
  my $button_frame = $t2->Frame(-borderwidth => 2, -relief => 'groove',
      			   )->pack(-side => 'bottom',-fill => 'x');
# frame for choice of operating system
  my $os_frame = $t2->Frame(-borderwidth => 2, -relief => 'groove',
			   -label=>'Operating system:',
			   )->pack(-side => 'top');  
# frame for choice of output type
#  my $view_frame = $t2->Frame(-borderwidth => 2, -relief => 'groove',
#			   -label=>'Output desired:',
#			   )->pack(-side => 'right');
# Radiobuttons for operating system.
  my @pl = qw/-side top -pady 2 /;
  my $op1 = 'Windows';
  my $op2 ='';
# 
 foreach my $op1 ( 'Windows', 'Linx/Unix') {
	$os_frame->Radiobutton(
            -text     => $op1,
            -variable => \$op2,
            -relief   => 'flat',
            -value    => $op1,
	    -command=> sub { 
       if(  $op1 eq 'Windows') {$view = 'yap'}
       else { $view = 'xdvi'}
              } )->pack(@pl);
   }
# Buttons at bottom  
           $button_frame->Button(-text => "Cancel", -command => sub{
	      $t2->withdraw} )->pack(-side => 'left');
	  $button_frame->Button(-text => "OK", 
	      -command => sub {$t2->withdraw; 
                               $file2 = 'config.dat';
			       open(FILEOUT, ">$file2");
			       print FILEOUT "$view\n";
#			       print "$view\n";
			       close(FILEOUT);
			       return $view} 
				)->pack(-side => 'right');
# other half of if statement, if window already exists.
	  } else {
	    $t2-> deiconify();
	    $t2->raise();
#	$entry->delete(0, 'end');
#        $data = "";
#	return $data;
    }
    }
# **********************************
